/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ApplicationModel;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.layout.LayoutConstants;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.util.LoggerManager;

public class UriDropTargetListener
implements DropTargetListener {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui.droptarget");
    DataSetSelector dss;
    ApplicationModel model;
    List<String> supportedFlavors;

    public UriDropTargetListener(DataSetSelector dss, ApplicationModel model) {
        this.model = model;
        this.dss = dss;
        this.supportedFlavors = new ArrayList<String>();
        this.supportedFlavors.add("text/uri-list;class=java.lang.String");
        this.supportedFlavors.add("application/x-java-url;class=java.net.URL");
        this.supportedFlavors.add("application/x-java-file-list;class=java.util.List");
    }

    private String getURI(DropTargetDropEvent dtde) {
        DataFlavor df;
        boolean haveAcceptedDrop = false;
        Bookmark item = null;
        List<Bookmark> items = null;
        if (logger.isLoggable(Level.FINE)) {
            for (DataFlavor df2 : dtde.getCurrentDataFlavors()) {
                logger.log(Level.FINE, "drop data flavor: {0} {1}", new Object[]{df2.getMimeType(), df2.getHumanPresentableName()});
            }
        }
        if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                dtde.acceptDrop(1);
                haveAcceptedDrop = true;
                logger.fine("looking, try using DataFlavor.stringFlavor to get uri");
                String data = ((String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor)).trim();
                logger.log(Level.FINER, "got string data: {0}", data);
                if (data.length() > 19 && data.startsWith("<bookmark-list")) {
                    items = Bookmark.parseBookmarks(data);
                } else {
                    item = data.length() > 14 && data.startsWith("<bookmark") ? Bookmark.parseBookmark(data) : new Bookmark.Item(data);
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "unable to get text/uri-list: {0}", ex.getMessage());
            }
        }
        if (item == null) {
            try {
                df = new DataFlavor("text/uri-list;class=java.lang.String");
                logger.fine("looking, try text/uri-list;class=java.lang.String");
                if (dtde.isDataFlavorSupported(df)) {
                    if (!haveAcceptedDrop) {
                        dtde.acceptDrop(1);
                        haveAcceptedDrop = true;
                    }
                    String data = String.valueOf(dtde.getTransferable().getTransferData(df));
                    logger.log(Level.FINER, "got string data: {0}", data);
                    if (data != null) {
                        item = new Bookmark.Item(data);
                    }
                } else {
                    logger.finer("not supported");
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "unable to get text/uri-list: {0}", ex.getMessage());
            }
        }
        if (item == null) {
            try {
                df = new DataFlavor("application/x-java-url;class=java.net.URL");
                logger.fine("looking, try application/x-java-url;class=java.net.URL");
                if (dtde.isDataFlavorSupported(df)) {
                    logger.fine("data flavor application/x-java-url;class=java.net.URL supported");
                    if (!haveAcceptedDrop) {
                        dtde.acceptDrop(1);
                        haveAcceptedDrop = true;
                    }
                    String data = String.valueOf(dtde.getTransferable().getTransferData(df));
                    logger.log(Level.FINER, "got string data: {0}", data);
                    if (data.startsWith("file://localhost/")) {
                        data = data.substring(16);
                    }
                    item = new Bookmark.Item(data);
                } else {
                    logger.finer("not supported");
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "unable to get application/x-java-url: {0}", ex.getMessage());
            }
        }
        if (item == null) {
            try {
                df = new DataFlavor("application/x-java-file-list;class=java.util.List");
                logger.fine("looking, try application/x-java-url;class=java.net.List");
                if (dtde.isDataFlavorSupported(df)) {
                    logger.fine("data flavor application/x-java-url;class=java.net.List supported");
                    if (!haveAcceptedDrop) {
                        dtde.acceptDrop(1);
                        haveAcceptedDrop = true;
                    }
                    List list = (List)dtde.getTransferable().getTransferData(df);
                    logger.log(Level.FINER, "got list data with number of elements: {0}", list.size());
                    if (list.size() == 1) {
                        String data = list.get(0).toString();
                        if (data.startsWith("file://localhost/")) {
                            data = data.substring(16);
                        }
                        item = new Bookmark.Item(data);
                    }
                } else {
                    logger.finer("not supported");
                }
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "unable to get application/x-java-file-list: {0}", ex.getMessage());
            }
        }
        String uri = null;
        if (item != null) {
            if (item instanceof Bookmark.Item) {
                uri = ((Bookmark.Item)item).getUri();
            } else {
                this.model.showMessage("only one URI can be dropped", "only one URI", 2);
            }
        } else if (items != null) {
            this.model.showMessage("only one URI can be dropped", "only one URI", 2);
        } else {
            this.model.showMessage("couldn't find URI in drop target", "no URI", 2);
        }
        return uri;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Component c;
        Object s = dtde.getSource();
        DasCanvasComponent cc = null;
        if (s instanceof DropTarget && (c = ((DropTarget)s).getComponent()) instanceof DasCanvasComponent) {
            cc = (DasCanvasComponent)c;
        }
        if (cc instanceof DasPlot) {
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrag(1);
            } else {
                for (String ss : this.supportedFlavors) {
                    try {
                        DataFlavor df = new DataFlavor(ss);
                        dtde.isDataFlavorSupported(df);
                    }
                    catch (ClassNotFoundException ex) {
                        logger.log(Level.FINE, null, ex);
                    }
                }
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        String uri = this.getURI(dtde);
        if (uri != null) {
            Plot plot;
            Component c;
            DasCanvasComponent cc = null;
            Object s = dtde.getSource();
            if (s instanceof DropTarget && (c = ((DropTarget)s).getComponent()) instanceof DasCanvasComponent) {
                cc = (DasCanvasComponent)c;
            }
            if (cc instanceof DasPlot) {
                plot = this.model.dom.getController().getPlotFor((Component)cc);
                if (plot == null) {
                    plot = null;
                }
            } else {
                plot = null;
            }
            if (plot == null) {
                DasCanvasComponent dcc = this.model.getCanvas().getCanvasComponentAt(dtde.getLocation().x, dtde.getLocation().y - 50);
                if (dcc != null) {
                    plot = this.model.dom.getController().getPlotFor((Component)dcc);
                    plot = this.model.dom.getController().addPlot(plot, LayoutConstants.BELOW);
                } else {
                    dcc = this.model.getCanvas().getCanvasComponentAt(dtde.getLocation().x, dtde.getLocation().y + 50);
                    if (dcc != null) {
                        plot = this.model.dom.getController().getPlotFor((Component)dcc);
                        plot = this.model.dom.getController().addPlot(plot, LayoutConstants.ABOVE);
                    }
                }
                if (plot == null) {
                    this.model.showMessage("URIs may only be dropped on plots, just above, or just below", "not plot target", 2);
                } else {
                    PlotElement pe = this.model.dom.getController().addPlotElement(plot, null);
                    this.model.dom.getController().setPlotElement(pe);
                    this.dss.setValue(uri);
                    this.dss.maybePlot(true);
                }
            } else {
                List<PlotElement> pe = this.model.dom.getController().getPlotElementsFor(plot);
                if (pe.isEmpty()) {
                    this.model.showMessage("no plot elements here", "no plot elements", 2);
                    return;
                }
                this.model.dom.getController().setPlotElement(pe.get(0));
                this.dss.setValue(uri);
                this.dss.maybePlot(true);
            }
        }
    }
}

